SELECT
"public".hazreduc.hazreduc_localid,
poly.enumvalue,
point.enumvalue,
"public".geopoint.pointno,
"public".geopoint.pointlocal_id,
"public".geopoint.longitude,
"public".geopoint.latitude,
"public".geopoint.distance,
"public".geopoint.bearing,
"public".geopoint.frompoint_guid,
"public".geopoint.userinputformat,
"public".geopoint.coordformat,
"public".geopoint.user_entered_x,
"public".geopoint.user_entered_y,
"public".geopoint.user_entered_mgrs
FROM
"public".hazreduc
INNER JOIN "public".hazreduc_has_geospatialinfo ON "public".hazreduc_has_geospatialinfo.hazreduc_guid = "public".hazreduc.hazreduc_guid
INNER JOIN "public".geospatialinfo ON "public".hazreduc_has_geospatialinfo.geospatialinfo_guid = "public".geospatialinfo.geospatialinfo_guid
INNER JOIN "public".geopoint ON "public".geopoint.geospatialinfo_guid = "public".geospatialinfo.geospatialinfo_guid
INNER JOIN "public".imsmaenum AS poly ON "public".geospatialinfo.shapeenum_guid = poly.imsmaenum_guid
INNER JOIN "public".imsmaenum AS point ON "public".geopoint.pointtypeenum_guid = point.imsmaenum_guid
WHERE
"public".hazreduc.hazreduc_localid = 'N-CS-VA-1607'
ORDER BY
"public".geopoint.pointno ASC
